*-------------------------------------------------------------------------------
*						Appendix IV Fig 1
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix IV Fig 1", replace 
set more off     


**------------------------------------------------------------------------------
* Step1: Generate Data
**------------------------------------------------------------------------------
clear
set obs 0
save plotdata1,replace emptyok

*Define occupation increase or decrease 
use "whole_occ2000.dta",clear
append using "whole_occ2010.dta"
append using "whole_occ2015.dta"

*Always exist
bys occ_number occ_name:egen num=count(share)
keep if num==3

keep occ_number occ_name share year

reshape wide share,i(occ_number occ_name) j(year)

gen d_share0015=share2015-share2000
gen type="up" if d_share0015>0
replace type="down" if d_share0015<0
tab type
keep occ_number occ_name type d_share0015
compress

drop d_share0015
append using plotdata1
save plotdata1,replace

clear
set obs 0
save plotdata2,replace emptyok

foreach j in "2000" "2010" "2015"{
use "`j'census_consistent.dta",clear

gen id_new=_n
collapse (count) id_new,by(consistent title_consistent new new_title)

bys consistent title_consistent:egen occ_pop=total(id_new)
gen ind_share=id_new/occ_pop

keep consistent title_consistent new new_title ind_share
duplicates drop 

gen ind2=ind_share^2

collapse (sum) ind2,by(consistent title_consistent)

rename (consistent title_consistent) (occ_number occ_name)

merge 1:1 occ_number occ_name using plotdata1
drop if _m==2
drop _m
rename ind2 HHI

gen year=`j'

append using plotdata2
save plotdata2,replace
}

**------------------------------------------------------------------------------
* Step2: Plot Data
**------------------------------------------------------------------------------
twoway (kdensity HHI if year==2000,lcolor(black%60) lp(dash)) ///
(kdensity HHI if year==2015,lcolor(black) lp(solid)), xsize(2) ysize(3.5) ///
xtitle("HHI Index") ytitle("Kdensity") xlabel(,nogrid) ylabel(,nogrid) ///
scheme(plotplain) legend(label(1 "2000") label(2 "2015") position(6) rows(1))
graph save "$Out_lab\appIV_Fig1a",replace
graph export "$Out_lab\appIV_Fig1a.png",replace


twoway (kdensity HHI if year==2000&type=="up",lcolor(black%60) lp(dash)) ///
(kdensity HHI if year==2015&type=="up",lcolor(black) lp(solid)), xsize(2) ysize(3.5) ///
xtitle("HHI Index") ytitle("Kdensity") xlabel(,nogrid) ylabel(,nogrid) ///
scheme(plotplain) legend(label(1 "2000") label(2 "2015") position(6) rows(1))
graph save "$Out_lab\appIV_Fig1b",replace
graph export "$Out_lab\appIV_Fig1b.png",replace


twoway (kdensity HHI if year==2000&type=="down",lcolor(black%60) lp(dash)) ///
(kdensity HHI if year==2015&type=="down",lcolor(black) lp(solid)), xsize(2) ysize(3.5) ///
xtitle("HHI Index") ytitle("Kdensity") xlabel(,nogrid) ylabel(,nogrid) ///
scheme(plotplain) legend(label(1 "2000") label(2 "2015") position(6) rows(1))
graph save "$Out_lab\appIV_Fig1c",replace
graph export "$Out_lab\appIV_Fig1c.png",replace

erase plotdata1.dta
erase plotdata2.dta

log close

